//
//  TWLoginViewController.h
//  Twitch Plugin
//
//  Created by Auston Stewart on 7/25/14.
//  Copyright (c) 2014 Twitch Interactive, Inc. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "TWWebViewController.h"

typedef enum {
	
	TWLoginViewControllerModeLogin,
	TWLoginViewControllerModeSignup
	
} TWLoginViewControllerMode;

@interface TWLoginViewController : TWWebViewController

- (id)initWithClientID:(NSString *)clientID redirectURI:(NSString *)redirectURI mode:(TWLoginViewControllerMode)mode;
- (void)dismissModalLoginViewController;

@end

@interface UINavigationController (LoginViewControllerPresentation)

+ (UINavigationController *) loginNavigationControllerForClientID:(NSString *)clientID redirectURI:(NSString *)redirectURI mode:(TWLoginViewControllerMode)mode;

@end
